//%attributes = {}
// Method: por_ WORK_MATERIAL_STOCK_REMOVE
// 2007.12.18-18:35:44 / Pasi Mankinen
// © Copyright 2007 Manage Applications
// Purpose: 
// 
// ------------------------------------------------------------

C_LONGINT:C283($por_lIndex; $por_lArrSize; $por_lMaterialStockStateSaved)
C_REAL:C285($por_rOrderedAmount; $por_rRemoveAmount; $por_rPurchaseCosts)
C_BOOLEAN:C305($por_fOK; $por_fDoNotUpdateProductPrices)
C_TEXT:C284($por_tInfo; $por_tStockEventType; $por_tStockPlace; $por_tSupplier; $por_tCustomer; $por_tCurrency; $por_tOrder_Row; $por_tProductionLot; $por_tCostCenter)
C_DATE:C307($por_dDate)

COMPILER_por
_tbl WRITE_STATE(por_kTbl; kTrue)
Case of 
	: (_sel RecsInSel(por_kTbl)<=0)
		IDLE:C311
	: (_rec Loaded(por_kTbl)=kFalse)
		_err MESSAGE(_lang Current("Purchase order row is not loaded"); Current method name:C684; kFalse)
		
	: (_fld ValueLong(por_kMaterial_Stock_State)=<>por_lMaterialRemovedState)
		$por_tInfo:="Row materials have already removed ("+_fld Name(por_kMaterial_Stock_State)+" -field value is "+String:C10(<>por_lMaterialRemovedState)+")"
		$por_tInfo:=_lang Current($por_tInfo)
		$por_tInfo:=$por_tInfo+ksCR+_tbl Name(por_kTbl)+": "+_fld ValueStr(por_kPurchase_Order_id)+"/"+String:C10(_fld ValueLong(por_kRow_Number))+", "+_fld ValueStr(por_kProduct_id)+ksCR
		_err MESSAGE($por_tInfo; Current method name:C684; kFalse)
		
	Else 
		_rec LOCKED_WAIT(por_kTbl; kTrue)
		If (OK=1)
			COMPILER_st
			$por_rOrderedAmount:=_fld ValueReal(por_kOrder_Amount)
			If ($por_rOrderedAmount<0)
				$por_tStockEventType:=<>st_tTypeFixRemoval
			Else 
				$por_tStockEventType:=<>st_tTypeRemoval
			End if 
			_sel RELATE_ONE(po_kPurchase_Order_ID; por_kPurchase_Order_id)
			$por_tStockPlace:=""
			$por_dDate:=_date Current(kTrue)
			$por_tSupplier:=_fld ValueStr(po_kSupplier_id)
			$por_tCustomer:=_fld ValueStr(po_kCompany_id)
			$por_tCurrency:=""
			$por_tOrder_Row:=por_OrderRow  // _fld ValueStr (por_kOrder_Row)
			$por_tProductionLot:=_fld ValueStr(por_kProduction_Lot)
			$por_fDoNotUpdateProductPrices:=False:C215
			$por_tCostCenter:=_fld ValueStr(por_kCost_Center)
			$por_rPurchaseCosts:=0
			_arr apCLEAR(->por_apRemoveMatTreeArr; 1)  //COMPILER_por
			ARRAY TEXT:C222(por_atCurrentProduct; 1)
			por_atCurrentProduct{1}:=_fld ValueStr(por_kProduct_id)
			tree_ DOWN_BUILD(->por_atCurrentProduct; "")
			tree_ STRUCT_ARR_BUILD(->por_asRemoveMatTreeStructure; ->por_asRemoveMatTreeWork; ->por_asRemoveMatTreeProduct; ->por_arRemoveMatTreeMultiplier; ->por_alRemoveMatTreeCalcType; ->por_alRemoveMatTreeLevel; kTrue; kTrue)
			//delete all but level 2 elements
			ARRAY LONGINT:C221(por_alFindLevel_tmp; 1)
			por_alFindLevel_tmp{1}:=2
			_arr apPICK_UP(->por_apRemoveMatTreeArr; ->por_alRemoveMatTreeLevel; ->por_alFindLevel_tmp)
			ARRAY LONGINT:C221(por_alFindLevel_tmp; 0)
			//Change desing multiplier to stock multiplier
			ARRAY TEXT:C222(por_atStockUnit_tmp; 0)
			If (tree_ MultiplierInStockUnit=kFalse)
				pr_ DESIGN1_AMOUNT_TO_STOCK1(->por_asRemoveMatTreeProduct; ->por_arRemoveMatTreeMultiplier; ->por_arRemoveMatTreeMultiplier; ->por_atStockUnit_tmp)
			End if 
			ARRAY TEXT:C222(por_atStockUnit_tmp; 0)
			//
			$por_lMaterialStockStateSaved:=kFalse
			$por_lArrSize:=Size of array:C274(por_asRemoveMatTreeStructure)
			$por_tInfo:=_lang Current("Removing materials from stock")+"..."+ksCR+_tbl Name(por_kTbl)+": "+_fld ValueStr(por_kPurchase_Order_id)+"/"+String:C10(_fld ValueLong(por_kRow_Number))+", "+_fld ValueStr(por_kProduct_id)
			_thm OPEN($por_lArrSize; $por_tInfo; _lang Current("Remove Materials"); True:C214)
			For ($por_lIndex; 1; $por_lArrSize)
				_thm UPDATE($por_lIndex)
				If (_thm Cancelled=kTrue)
					$por_lIndex:=$por_lArrSize+1
				Else 
					$por_rRemoveAmount:=$por_rOrderedAmount*por_arRemoveMatTreeMultiplier{$por_lIndex}
					If ($por_rRemoveAmount#0)
						$por_fOK:=st_C_New($por_tStockEventType; por_asRemoveMatTreeProduct{$por_lIndex}; -$por_rRemoveAmount; $por_tStockPlace; $por_dDate; $por_tSupplier; $por_tCustomer; -1; -1; $por_tCurrency; $por_tOrder_Row; $por_fDoNotUpdateProductPrices; $por_tProductionLot; $por_tCostCenter; $por_rPurchaseCosts)
					Else 
						$por_fOK:=True:C214
					End if 
					If (($por_fOK=True:C214) & ($por_lMaterialStockStateSaved=kFalse))
						_rec LOCKED_WAIT(por_kTbl; kTrue)
						If (OK=1)
							_fld VALUE_LONG_SET(kSet; por_kMaterial_Stock_State; <>por_lMaterialRemovedState)
							_rec SAVE(por_kTbl)
							If (OK=1)
								$por_lMaterialStockStateSaved:=kTrue
							End if 
						End if 
					End if 
				End if 
			End for 
			_thm CLOSE
			_arr apCLEAR(->por_apRemoveMatTreeArr; 1)
			ARRAY TEXT:C222(por_atCurrentProduct; 0)
		End if 
		
End case 
_tbl WRITE_STATE(por_kTbl; kPrevious)
